(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     68966,       1499]
NotebookOptionsPosition[     67340,       1445]
NotebookOutlinePosition[     68449,       1484]
CellTagsIndexPosition[     68406,       1481]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"AKSIJALNO", " ", "NAPREZANJE"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"N1", "[", "x_", "]"}], ":=", 
    RowBox[{"1", "-", 
     FractionBox["x", "L"]}]}], ";", " ", 
   RowBox[{
    RowBox[{"N2", "[", "x_", "]"}], ":=", 
    FractionBox["x", "L"]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Matrica", " ", "interpolacionh", " ", "funkcija"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"matricaNaks", ":=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"N1", "[", "x", "]"}], ",", 
       RowBox[{"N2", "[", "x", "]"}]}], "}"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Matrica", " ", "veze", " ", "deformacija", " ", "i", " ", "generalisanih",
     " ", "pomeranja"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"matricaPrvihIzvodaNaks", ":=", 
    RowBox[{"D", "[", 
     RowBox[{"matricaNaks", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Matrica", " ", "elasticnosti"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DD", ":=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"Em", "*", "A"}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Matrica", " ", "krutosti"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kaks", ":=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "matricaPrvihIzvodaNaks", "]"}], ".", "DD", 
      ".", "matricaPrvihIzvodaNaks"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "L"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<AKSIJALNO NAPREZANJE\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<matricaPrvihIzvodaNaks = \>\"", ",", 
    RowBox[{"MatrixForm", "[", "matricaPrvihIzvodaNaks", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<kaks = \!\(\*FractionBox[\(EA\), \(L\)]\)\>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"kaks", "/", 
       RowBox[{"(", 
        FractionBox[
         RowBox[{"Em", "*", "A"}], "L"], ")"}]}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"SAVIJANJE", " ", "U", " ", "x"}], "-", 
    RowBox[{"y", " ", "RAVNI"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"N1xy", "[", "x_", "]"}], ":=", 
   TagBox[
    RowBox[{"1", "-", 
     FractionBox[
      RowBox[{"3", "*", " ", 
       SuperscriptBox["x", "2"]}], 
      SuperscriptBox["L", "2"]], "+", 
     FractionBox[
      RowBox[{"2", " ", "*", 
       SuperscriptBox["x", "3"]}], 
      SuperscriptBox["L", "3"]]}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";", 
  RowBox[{
   RowBox[{"N2xy", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "-", 
    FractionBox[
     RowBox[{"2", " ", "*", 
      SuperscriptBox["x", "2"]}], "L"], "+", 
    FractionBox[
     SuperscriptBox["x", "3"], 
     SuperscriptBox["L", "2"]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"N3xy", "[", "x_", "]"}], ":=", 
    TagBox[
     RowBox[{"\[InvisibleSpace]", 
      TagBox[
       RowBox[{
        FractionBox[
         RowBox[{"3", "*", " ", 
          SuperscriptBox["x", "2"]}], 
         SuperscriptBox["L", "2"]], "-", 
        FractionBox[
         RowBox[{"2", "*", " ", 
          SuperscriptBox["x", "3"]}], 
         SuperscriptBox["L", "3"]]}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ";", 
   RowBox[{
    RowBox[{"N4xy", "[", "x_", "]"}], ":=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["x", "2"], "L"]}], "+", 
     FractionBox[
      SuperscriptBox["x", "3"], 
      SuperscriptBox["L", "2"]]}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"SAVIJANJE", " ", "U", " ", "x"}], "-", 
    RowBox[{"z", " ", "RAVNI"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"N1xz", "[", "x_", "]"}], ":=", 
   TagBox[
    RowBox[{"1", "-", 
     FractionBox[
      RowBox[{"3", "*", " ", 
       SuperscriptBox["x", "2"]}], 
      SuperscriptBox["L", "2"]], "+", 
     FractionBox[
      RowBox[{"2", " ", "*", 
       SuperscriptBox["x", "3"]}], 
      SuperscriptBox["L", "3"]]}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";", 
  RowBox[{
   RowBox[{"N2xz", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"-", "x"}], "+", 
    FractionBox[
     RowBox[{"2", " ", "*", 
      SuperscriptBox["x", "2"]}], "L"], "-", 
    FractionBox[
     SuperscriptBox["x", "3"], 
     SuperscriptBox["L", "2"]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"N3xz", "[", "x_", "]"}], ":=", 
    TagBox[
     RowBox[{"\[InvisibleSpace]", 
      TagBox[
       RowBox[{
        FractionBox[
         RowBox[{"3", "*", " ", 
          SuperscriptBox["x", "2"]}], 
         SuperscriptBox["L", "2"]], "-", 
        FractionBox[
         RowBox[{"2", "*", " ", 
          SuperscriptBox["x", "3"]}], 
         SuperscriptBox["L", "3"]]}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ";", 
   RowBox[{
    RowBox[{"N4xz", "[", "x_", "]"}], ":=", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "2"], "L"], "-", 
     FractionBox[
      SuperscriptBox["x", "3"], 
      SuperscriptBox["L", "2"]]}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Matrica", " ", "interpolacionh", " ", "funkcija"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matricaNxy", ":=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"N1xy", "[", "x", "]"}], ",", 
      RowBox[{"N2xy", "[", "x", "]"}], ",", 
      RowBox[{"N3xy", "[", "x", "]"}], ",", 
      RowBox[{"N4xy", "[", "x", "]"}]}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matricaDrugihIzvodaNxy", ":=", 
   RowBox[{"D", "[", 
    RowBox[{"matricaNxy", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matricaPrvihIzvodaNxy", ":=", 
   RowBox[{"D", "[", 
    RowBox[{"matricaNxy", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DDxy", ":=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"Em", "*", "Iz"}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kxy", ":=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "matricaDrugihIzvodaNxy", "]"}], ".", "DDxy", 
      ".", "matricaDrugihIzvodaNxy"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "L"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DDxyg", ":=", 
   RowBox[{"{", 
    RowBox[{"{", "S", "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kxyg", ":=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "matricaPrvihIzvodaNxy", "]"}], ".", "DDxyg", 
      ".", "matricaPrvihIzvodaNxy"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "L"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matricaNxz", ":=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"N1xz", "[", "x", "]"}], ",", 
      RowBox[{"N2xz", "[", "x", "]"}], ",", 
      RowBox[{"N3xz", "[", "x", "]"}], ",", 
      RowBox[{"N4xz", "[", "x", "]"}]}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matricaDrugihIzvodaNxz", ":=", 
   RowBox[{"D", "[", 
    RowBox[{"matricaNxz", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matricaPrvihIzvodaNxz", ":=", 
   RowBox[{"D", "[", 
    RowBox[{"matricaNxz", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DDxz", ":=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"Em", "*", "Iy"}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kxz", ":=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "matricaDrugihIzvodaNxz", "]"}], ".", "DDxz", 
      ".", "matricaDrugihIzvodaNxz"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "L"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DDxzg", ":=", 
   RowBox[{"{", 
    RowBox[{"{", "S", "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kxzg", ":=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "matricaPrvihIzvodaNxz", "]"}], ".", "DDxzg", 
      ".", "matricaPrvihIzvodaNxz"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "L"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<SAVIJANJE U x-y RAVNI\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<matricaDrugihIzvodaNxy = \>\"", ",", 
    RowBox[{"MatrixForm", "[", "matricaDrugihIzvodaNxy", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<matricaPrvihIzvodaNxy = \>\"", ",", 
    RowBox[{"MatrixForm", "[", "matricaPrvihIzvodaNxy", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Konvencionalna matrica krutosti kxy = \!\(\*FractionBox[\(EIz\), \
SuperscriptBox[\(L\), \(3\)]]\)\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"kxy", "/", 
      RowBox[{"(", 
       FractionBox[
        RowBox[{"Em", "*", "Iz"}], 
        SuperscriptBox["L", "3"]], ")"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Geometrijska matrica krutosti kxyg = \!\(\*FractionBox[\(S\), \(30  L\
\)]\)\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"kxyg", "/", 
      RowBox[{"(", 
       FractionBox["S", 
        RowBox[{"30", "*", "L"}]], ")"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<SAVIJANJE U x-z RAVNI\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<matricaDrugihIzvodaNxz  = \>\"", ",", 
    RowBox[{"MatrixForm", "[", "matricaDrugihIzvodaNxz", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<matricaPrvihIzvodaNxz = \>\"", ",", 
    RowBox[{"MatrixForm", "[", "matricaPrvihIzvodaNxz", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Konvencionalna matrica krutosti kxz = \!\(\*FractionBox[\(EIy\), \
SuperscriptBox[\(L\), \(3\)]]\)\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"kxz", "/", 
      RowBox[{"(", 
       FractionBox[
        RowBox[{"Em", "*", "Iy"}], 
        SuperscriptBox["L", "3"]], ")"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Geometrijska matrica krutosti kxzg = \!\(\*FractionBox[\(S\), \(30  L\
\)]\)\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"kxzg", "/", 
      RowBox[{"(", 
       FractionBox["S", 
        RowBox[{"30", "*", "L"}]], ")"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Exit", "[", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.42674044134375*^9, 3.426740474640625*^9}, {
   3.5187122094375*^9, 3.51871221621875*^9}, 3.5187152381875*^9, {
   3.518718762296875*^9, 3.518718768625*^9}, {3.518749066125*^9, 
   3.51874916965625*^9}, {3.518749231390625*^9, 3.518749235875*^9}, {
   3.5626104974956865`*^9, 3.5626106034175615`*^9}, {3.5626106949956865`*^9, 
   3.5626107834644365`*^9}, 3.5626108661206865`*^9, {3.5626109015113115`*^9, 
   3.5626109029331865`*^9}, {3.5626109945113115`*^9, 
   3.5626110090269365`*^9}, {3.5626110701206865`*^9, 
   3.5626110868863115`*^9}, {3.5626111201519365`*^9, 
   3.5626111244331865`*^9}, {3.5626113160113115`*^9, 
   3.5626113207613115`*^9}, {3.5626113917144365`*^9, 
   3.5626114186363115`*^9}, {3.5626114518238115`*^9, 
   3.5626115144956865`*^9}, {3.5626119386831865`*^9, 
   3.5626119506206865`*^9}, {3.5626121764956865`*^9, 
   3.5626122176831865`*^9}, {3.5626122505581865`*^9, 
   3.5626125456206865`*^9}, {3.5626125830425615`*^9, 
   3.5626125863238115`*^9}, {3.5626126280738115`*^9, 
   3.5626127074956865`*^9}, {3.5626127397925615`*^9, 
   3.5626127970113115`*^9}, {3.5626128447300615`*^9, 
   3.5626129554488115`*^9}, {3.5626130264488115`*^9, 
   3.5626130337144365`*^9}, {3.5626131452456865`*^9, 
   3.5626132179644365`*^9}, {3.5626132653081865`*^9, 
   3.5626133557144365`*^9}, {3.5626133920113115`*^9, 
   3.5626135464331865`*^9}, {3.5626135790269365`*^9, 
   3.5626135899175615`*^9}, {3.5626136316519365`*^9, 
   3.5626138386050615`*^9}, {3.5626138773394365`*^9, 
   3.5626139275113115`*^9}, {3.5626139583550615`*^9, 
   3.5626141640113115`*^9}, {3.5626142273238115`*^9, 
   3.5626143722613115`*^9}, {3.5626144208863115`*^9, 
   3.5626144264644365`*^9}, {3.5626144771831865`*^9, 
   3.5626145831675615`*^9}, {3.5626906969375*^9, 3.56269073353125*^9}, {
   3.56269078115625*^9, 3.5626908654375*^9}, {3.562691030203125*^9, 
   3.56269109484375*^9}, {3.562691359515625*^9, 3.562691470578125*^9}, {
   3.562691501671875*^9, 3.56269159234375*^9}, {3.56269166846875*^9, 
   3.562691680453125*^9}, {3.5626917133125*^9, 3.562691718625*^9}, {
   3.562691753734375*^9, 3.562691840390625*^9}, {3.562691903734375*^9, 
   3.5626922054375*^9}, {3.562692284140625*^9, 3.562692291328125*^9}, {
   3.562692338921875*^9, 3.5626924005625*^9}, {3.562692439453125*^9, 
   3.562692575578125*^9}, {3.562692703765625*^9, 3.562692722125*^9}, {
   3.56269286946875*^9, 3.562692903734375*^9}, {3.562692975453125*^9, 
   3.562693055109375*^9}, {3.562693091546875*^9, 3.562693251828125*^9}, {
   3.562693285328125*^9, 3.562693309875*^9}, {3.562750336671875*^9, 
   3.562750382484375*^9}, {3.5627504301875*^9, 3.56275053103125*^9}, {
   3.562750604234375*^9, 3.562750775203125*^9}, {3.56275081690625*^9, 
   3.562750869265625*^9}, {3.562750934375*^9, 3.562750961390625*^9}, {
   3.562751035890625*^9, 3.56275112509375*^9}, {3.562751186734375*^9, 
   3.562751249671875*^9}, {3.562751303828125*^9, 3.562751331578125*^9}, {
   3.56275138959375*^9, 3.5627518421875*^9}, {3.562751874234375*^9, 
   3.5627519339375*^9}, {3.562751988703125*^9, 3.562752017546875*^9}, {
   3.56275209115625*^9, 3.562752117765625*^9}, {3.562752185328125*^9, 
   3.5627522043125*^9}, {3.562752244875*^9, 3.562752270734375*^9}, {
   3.562752341703125*^9, 3.56275235709375*^9}, {3.562752766625*^9, 
   3.56275280175*^9}, 3.56275300915625*^9, {3.562753039359375*^9, 
   3.562753077921875*^9}, {3.562753115953125*^9, 3.562753131046875*^9}, {
   3.562753385953125*^9, 3.562753573390625*^9}, {3.56275377496875*^9, 
   3.56275388703125*^9}, {3.56275394325*^9, 3.56275417715625*^9}, {
   3.562754282703125*^9, 3.56275433646875*^9}, {3.562754376203125*^9, 
   3.562754385296875*^9}, {3.562754423703125*^9, 3.56275443159375*^9}, {
   3.562754587671875*^9, 3.562754641203125*^9}, {3.56275467425*^9, 
   3.56275469946875*^9}, {3.562755193203125*^9, 3.562755308078125*^9}, {
   3.56275535428125*^9, 3.562755490328125*^9}, {3.562755601703125*^9, 
   3.56275560465625*^9}, {3.562755647203125*^9, 3.5627556990625*^9}, {
   3.562755735078125*^9, 3.562755757953125*^9}, {3.562755811953125*^9, 
   3.5627558276875*^9}, {3.56275593371875*^9, 3.56275596903125*^9}, {
   3.562756140171875*^9, 3.562756356328125*^9}, 3.5627563875*^9, {
   3.562756420640625*^9, 3.562756548375*^9}, {3.562756593359375*^9, 
   3.56275666021875*^9}, {3.562756752609375*^9, 3.562756834015625*^9}, 
   3.562756909421875*^9, {3.56275698109375*^9, 3.562757053640625*^9}, {
   3.56276793115625*^9, 3.562767931859375*^9}, {3.562767963390625*^9, 
   3.562768010171875*^9}, {3.562768049484375*^9, 3.562768177859375*^9}, {
   3.562768352515625*^9, 3.56276838253125*^9}, {3.56276841659375*^9, 
   3.5627685359375*^9}, {3.5627685843125*^9, 3.5627686093125*^9}, {
   3.5627686506875*^9, 3.562768741953125*^9}, 3.562768803203125*^9, {
   3.56276883584375*^9, 3.562769253203125*^9}, {3.562769285859375*^9, 
   3.56276958175*^9}, {3.5627696173125*^9, 3.562769698296875*^9}, {
   3.56276985240625*^9, 3.5627700383125*^9}, {3.5627701251875*^9, 
   3.56277015334375*^9}, {3.562770258921875*^9, 3.5627703725625*^9}, {
   3.562770463734375*^9, 3.562770702609375*^9}, {3.562770763*^9, 
   3.56277079921875*^9}, {3.562770846671875*^9, 3.56277086584375*^9}, {
   3.562770954859375*^9, 3.562771082734375*^9}, {3.562771195015625*^9, 
   3.562771304875*^9}, {3.56277165228125*^9, 3.562771687328125*^9}, {
   3.562773408609375*^9, 3.562773457953125*^9}, {3.56277356215625*^9, 
   3.5627736329375*^9}, 3.5627737271875*^9, {3.562773779671875*^9, 
   3.562773855515625*^9}, {3.56277389146875*^9, 3.56277389153125*^9}, {
   3.5627739373125*^9, 3.56277407025*^9}, {3.56277422525*^9, 
   3.562774375640625*^9}, {3.56277461803125*^9, 3.562774706953125*^9}, {
   3.56277476309375*^9, 3.562774812265625*^9}, {3.5627748606875*^9, 
   3.562774930890625*^9}, {3.562775073953125*^9, 3.56277507684375*^9}, {
   3.562775135953125*^9, 3.562775148484375*^9}, {3.5627751920625*^9, 
   3.56277527415625*^9}, 3.562775409390625*^9, 3.5627754865625*^9, {
   3.56277552584375*^9, 3.562775526296875*^9}, 3.562775611421875*^9, 
   3.562775652078125*^9, {3.56277581284375*^9, 3.562775948203125*^9}, 
   3.562775978609375*^9, {3.562776034328125*^9, 3.562776049953125*^9}, 
   3.56277613159375*^9, 3.562776215921875*^9, {3.562776583890625*^9, 
   3.562776591234375*^9}, {3.562776700203125*^9, 3.562776701578125*^9}, {
   3.562776737640625*^9, 3.5627767391875*^9}, {3.562776876328125*^9, 
   3.5627768776875*^9}, {3.5629366808125*^9, 3.56293668353125*^9}, {
   3.56293895546875*^9, 3.56293903421875*^9}, {3.562939139828125*^9, 
   3.562939199328125*^9}, {3.562940940625*^9, 3.562940986*^9}, {
   3.562941027640625*^9, 3.562941045375*^9}, {3.5629410894375*^9, 
   3.562941161953125*^9}, {3.5629412160625*^9, 3.562941220640625*^9}, {
   3.562941253359375*^9, 3.562941255015625*^9}, {3.562941328953125*^9, 
   3.562941344921875*^9}, {3.562941380265625*^9, 3.562941435234375*^9}, {
   3.562942345390625*^9, 3.562942445921875*^9}, {3.56294253203125*^9, 
   3.56294266484375*^9}, {3.56294270634375*^9, 3.562942818828125*^9}, {
   3.56294285459375*^9, 3.56294287003125*^9}, {3.56294291203125*^9, 
   3.562942952546875*^9}, {3.562943050390625*^9, 3.562943066703125*^9}, {
   3.5629431814375*^9, 3.562943182953125*^9}, {3.562943217078125*^9, 
   3.562943316296875*^9}, {3.562943358984375*^9, 3.562943384515625*^9}, {
   3.562943788203125*^9, 3.562943944921875*^9}, {3.5629440155625*^9, 
   3.562944119546875*^9}, {3.562944169546875*^9, 3.562944200421875*^9}, {
   3.562944247453125*^9, 3.562944315765625*^9}, {3.562944371359375*^9, 
   3.562944405609375*^9}, {3.56294446365625*^9, 3.562944482171875*^9}, {
   3.562944528078125*^9, 3.56294466890625*^9}, {3.56294470896875*^9, 
   3.562944739046875*^9}, {3.562944898125*^9, 3.56294496015625*^9}, {
   3.562945014703125*^9, 3.562945020015625*^9}, {3.56294506553125*^9, 
   3.5629450918125*^9}, {3.562945149421875*^9, 3.562945275703125*^9}, {
   3.562945319375*^9, 3.562945464109375*^9}, {3.562945507953125*^9, 
   3.56294558653125*^9}, {3.562945637078125*^9, 3.5629457184375*^9}, {
   3.56294577165625*^9, 3.56294587825*^9}, {3.562945914*^9, 
   3.562946216375*^9}, {3.562946252234375*^9, 3.5629462554375*^9}, {
   3.5629464950625*^9, 3.56294650103125*^9}, {3.562946546109375*^9, 
   3.562946562734375*^9}, {3.56294659515625*^9, 3.562946814640625*^9}, {
   3.562946936875*^9, 3.56294698584375*^9}, {3.562947168484375*^9, 
   3.562947204609375*^9}, {3.562947243046875*^9, 3.562947261046875*^9}, {
   3.56294761059375*^9, 3.56294763496875*^9}, {3.562947694640625*^9, 
   3.562947704734375*^9}, {3.562947768390625*^9, 3.5629477780625*^9}, {
   3.562947823625*^9, 3.5629478600625*^9}, {3.562947994171875*^9, 
   3.562948059203125*^9}, {3.562948117625*^9, 3.562948268765625*^9}, {
   3.5629485424375*^9, 3.562948595734375*^9}, {3.5629486926875*^9, 
   3.562948782890625*^9}, {3.56294885*^9, 3.562948884203125*^9}, {
   3.56294891465625*^9, 3.562948954140625*^9}, {3.562948988640625*^9, 
   3.562949126078125*^9}, {3.562949164453125*^9, 3.56294924128125*^9}, {
   3.562949283703125*^9, 3.5629494541875*^9}, {3.562949486859375*^9, 
   3.562949510515625*^9}, {3.56294954153125*^9, 3.56294956921875*^9}, {
   3.5629496299375*^9, 3.562949792703125*^9}, {3.562949840734375*^9, 
   3.56294988334375*^9}, {3.562949948640625*^9, 3.562949969296875*^9}, 
   3.56295141759375*^9, {3.562952128265625*^9, 3.562952250203125*^9}, {
   3.562952281546875*^9, 3.562952320390625*^9}, {3.562952362578125*^9, 
   3.5629523925*^9}, {3.562952445984375*^9, 3.56295244728125*^9}, {
   3.562952478984375*^9, 3.562952517671875*^9}, {3.5629525484375*^9, 
   3.562952643640625*^9}, {3.562952686109375*^9, 3.562952715625*^9}, {
   3.56299451096875*^9, 3.56299451903125*^9}, {3.56299455203125*^9, 
   3.5629946820625*^9}, {3.56299474203125*^9, 3.5629948345625*^9}, {
   3.562994946421875*^9, 3.562994962203125*^9}, {3.562995069484375*^9, 
   3.562995082203125*^9}, {3.5629952326875*^9, 3.562995254234375*^9}, {
   3.562996861171875*^9, 3.562996884765625*^9}, {3.56299705271875*^9, 
   3.56299706065625*^9}, {3.562997159859375*^9, 3.562997161546875*^9}, {
   3.563011698125*^9, 3.56301173509375*^9}, {3.56301288034375*^9, 
   3.563013045953125*^9}, {3.563013099515625*^9, 3.5630131098125*^9}, {
   3.56301315309375*^9, 3.56301336778125*^9}, {3.56301340403125*^9, 
   3.56301347778125*^9}, {3.56301351603125*^9, 3.5630136195625*^9}, {
   3.5630136946875*^9, 3.563013762734375*^9}, {3.563013817625*^9, 
   3.56301390890625*^9}, {3.5630139728125*^9, 3.56301404434375*^9}, 
   3.563014076890625*^9, {3.563014119328125*^9, 3.563014233140625*^9}, {
   3.563014284015625*^9, 3.5630143310625*^9}, {3.563014365875*^9, 
   3.563014377921875*^9}, {3.56301442346875*^9, 3.5630144815625*^9}, 
   3.56301451178125*^9, {3.56301460725*^9, 3.563014608984375*^9}, {
   3.563014672390625*^9, 3.5630146744375*^9}, {3.56301472803125*^9, 
   3.563014947609375*^9}, {3.563015046671875*^9, 3.5630150679375*^9}, {
   3.563015548*^9, 3.563015613875*^9}, {3.56301688315625*^9, 
   3.563017278875*^9}, {3.56301734140625*^9, 3.563017446640625*^9}, {
   3.56301748709375*^9, 3.563017559640625*^9}, {3.56301759615625*^9, 
   3.5630176284375*^9}, {3.56301765853125*^9, 3.563017684640625*^9}, {
   3.563017731578125*^9, 3.5630177556875*^9}, {3.563017789890625*^9, 
   3.563017824140625*^9}, {3.56301789809375*^9, 3.5630179544375*^9}, {
   3.563018012046875*^9, 3.563018242171875*^9}, {3.56301837096875*^9, 
   3.56301839975*^9}, {3.563018575640625*^9, 3.563018580578125*^9}, {
   3.563018762265625*^9, 3.563019001328125*^9}, {3.563019040671875*^9, 
   3.563019062171875*^9}, {3.563019093953125*^9, 3.56301930178125*^9}, {
   3.5630193469375*^9, 3.5630193893125*^9}, 3.5630194296875*^9, {
   3.56301947225*^9, 3.56301949659375*^9}, {3.563019556671875*^9, 
   3.56301967515625*^9}, {3.563019734046875*^9, 3.5630197854375*^9}, {
   3.56302015096875*^9, 3.563020184578125*^9}, {3.563020215109375*^9, 
   3.56302027815625*^9}, {3.56302044815625*^9, 3.563020517578125*^9}, {
   3.56312269865625*^9, 3.56312274053125*^9}, 3.563186172328125*^9, {
   3.563186220671875*^9, 3.563186229703125*^9}, {3.563995027015625*^9, 
   3.563995027875*^9}, 3.563995082109375*^9, {3.56399518671875*^9, 
   3.563995190234375*^9}, {3.5639952405*^9, 3.563995247734375*^9}, {
   3.563995661953125*^9, 3.56399575875*^9}, {3.56399578928125*^9, 
   3.56399588*^9}, {3.563995919640625*^9, 3.5639959735625*^9}, {
   3.563996013578125*^9, 3.563996155984375*^9}, {3.5639961880625*^9, 
   3.563996218578125*^9}, {3.56399626715625*^9, 3.563996293734375*^9}, {
   3.563996360671875*^9, 3.563996391984375*^9}, {3.56399644215625*^9, 
   3.563996445296875*^9}, {3.563996515453125*^9, 3.563996516046875*^9}, {
   3.563996560484375*^9, 3.563996622375*^9}, {3.563996663328125*^9, 
   3.5639966835*^9}, {3.563996744765625*^9, 3.563996751203125*^9}, {
   3.563996810203125*^9, 3.563996854296875*^9}, {3.56399689259375*^9, 
   3.56399690365625*^9}, {3.56399694065625*^9, 3.56399698490625*^9}, {
   3.563997060796875*^9, 3.5639970750625*^9}, {3.563997183796875*^9, 
   3.56399718921875*^9}, {3.563997219734375*^9, 3.56399724928125*^9}, {
   3.56399735025*^9, 3.563997497203125*^9}, {3.563997547375*^9, 
   3.56399756071875*^9}, {3.563997617375*^9, 3.563997630421875*^9}, {
   3.563997745296875*^9, 3.563997788140625*^9}, {3.563997824265625*^9, 
   3.563997884859375*^9}, {3.5639979198125*^9, 3.563997950390625*^9}, {
   3.5639980025*^9, 3.563998005953125*^9}, {3.56399809909375*^9, 
   3.563998132078125*^9}, {3.56399823025*^9, 3.56399823721875*^9}, {
   3.5639983900625*^9, 3.5639984738125*^9}, {3.5639985405*^9, 
   3.563998554375*^9}, {3.56399861128125*^9, 3.563998614109375*^9}, {
   3.56399865471875*^9, 3.563998655*^9}, {3.563998687328125*^9, 
   3.563998688109375*^9}, {3.5639987701875*^9, 3.56399891515625*^9}, {
   3.563998962640625*^9, 3.563999119328125*^9}, {3.56399915046875*^9, 
   3.563999256328125*^9}, {3.5639992895625*^9, 3.56399929815625*^9}, {
   3.563999375296875*^9, 3.56399939*^9}, {3.563999441328125*^9, 
   3.563999484234375*^9}, {3.5639995161875*^9, 3.56399964778125*^9}, {
   3.563999687046875*^9, 3.56399989271875*^9}, {3.5639999238125*^9, 
   3.5639999278125*^9}, 3.564000151015625*^9, {3.5640001833125*^9, 
   3.564000183765625*^9}, {3.564031730203125*^9, 3.56403173528125*^9}, 
   3.564031766125*^9, {3.5640318500625*^9, 3.564031986734375*^9}, {
   3.564032021453125*^9, 3.56403212996875*^9}, {3.564032322375*^9, 
   3.56403238559375*^9}, {3.564032456109375*^9, 3.564032466375*^9}, {
   3.564032790671875*^9, 3.564032942*^9}, {3.564032984796875*^9, 
   3.564033024359375*^9}, {3.56403308221875*^9, 3.56403319540625*^9}, {
   3.56403325040625*^9, 3.56403325778125*^9}, {3.56403329203125*^9, 
   3.56403347015625*^9}, {3.564033507515625*^9, 3.5640335275625*^9}, {
   3.56403360396875*^9, 3.56403367325*^9}, {3.564033738046875*^9, 
   3.564033776140625*^9}, {3.564033825453125*^9, 3.564033837640625*^9}, {
   3.56403389365625*^9, 3.56403422803125*^9}, 3.564034285734375*^9, {
   3.564034320921875*^9, 3.564034322421875*^9}, {3.564034366390625*^9, 
   3.564034424875*^9}, {3.56403448228125*^9, 3.564034504359375*^9}, {
   3.564034549890625*^9, 3.564034668046875*^9}, {3.564034702421875*^9, 
   3.56403488578125*^9}, 3.564034920765625*^9, {3.564034959765625*^9, 
   3.564035033734375*^9}, {3.56403506734375*^9, 3.564035208140625*^9}, {
   3.564035249421875*^9, 3.5640353524375*^9}, {3.564035392328125*^9, 
   3.56403539290625*^9}, {3.564035459015625*^9, 3.5640354774375*^9}, {
   3.56403559146875*^9, 3.564035624921875*^9}, {3.564035746921875*^9, 
   3.564035935*^9}, {3.56403606671875*^9, 3.564036149828125*^9}, 
   3.56403620884375*^9, {3.564036289375*^9, 3.564036354484375*^9}, {
   3.56403659615625*^9, 3.56403659978125*^9}, {3.56404995503125*^9, 
   3.564049965515625*^9}, {3.56405000234375*^9, 3.564050037671875*^9}, {
   3.56405007378125*^9, 3.56405024271875*^9}, {3.56405028209375*^9, 
   3.5640502826875*^9}, {3.56405037984375*^9, 3.564050420796875*^9}, {
   3.564050464125*^9, 3.564050466328125*^9}, {3.5640505115625*^9, 
   3.5640505215625*^9}, {3.56405056178125*^9, 3.5640505628125*^9}, {
   3.5640506076875*^9, 3.56405061428125*^9}, {3.564050653453125*^9, 
   3.564050742640625*^9}, {3.56405077290625*^9, 3.564050773515625*^9}, {
   3.56405083053125*^9, 3.5640508876875*^9}, {3.56420234690625*^9, 
   3.5642023496875*^9}, {3.56420240290625*^9, 3.564202403921875*^9}, {
   3.564202552515625*^9, 3.56420258846875*^9}, {3.5642027979375*^9, 
   3.564202925640625*^9}, {3.56420298246875*^9, 3.56420299053125*^9}, {
   3.564203060078125*^9, 3.56420310940625*^9}, {3.564203156828125*^9, 
   3.564203270703125*^9}, {3.56420348678125*^9, 3.5642034895*^9}, {
   3.5642035271875*^9, 3.564203529703125*^9}, {3.5642036843125*^9, 
   3.56420370534375*^9}, {3.564203863484375*^9, 3.564203883671875*^9}, {
   3.5642063060625*^9, 3.564206442109375*^9}, {3.56420652778125*^9, 
   3.56420655084375*^9}, {3.607308635253486*^9, 3.607308637011587*^9}, {
   3.607458408694583*^9, 3.6074584104261866`*^9}, {3.6170785241058693`*^9, 
   3.6170785848159547`*^9}, {3.617078668206072*^9, 3.617078693626107*^9}, {
   3.6170787658062077`*^9, 3.617078827036294*^9}, {3.6170788674363503`*^9, 
   3.6170788679763513`*^9}, {3.6170789522864695`*^9, 
   3.6170790256565723`*^9}, {3.617079129566717*^9, 3.617079147736743*^9}, {
   3.6170792103268304`*^9, 3.6170794048671026`*^9}, {3.6170795444703135`*^9, 
   3.6170795775003595`*^9}, {3.6170796758704977`*^9, 
   3.6170796871405134`*^9}, {3.6170797260105677`*^9, 
   3.6170797264605684`*^9}, {3.6170798043106775`*^9, 3.617079804460677*^9}, {
   3.617079893000801*^9, 3.6170798937208023`*^9}, {3.6170799240208445`*^9, 
   3.6170799280908504`*^9}, {3.617079966210904*^9, 3.6170799973109474`*^9}, {
   3.6170800958410854`*^9, 3.6170801271011295`*^9}, 3.6170802981013684`*^9, {
   3.6170803387414255`*^9, 3.617080368541467*^9}, {3.6170804071415215`*^9, 
   3.6170804396815667`*^9}, {3.617080525911688*^9, 3.6170806702518897`*^9}, {
   3.617080721911962*^9, 3.617080902812215*^9}, {3.6170809389422655`*^9, 
   3.6170809751323166`*^9}, {3.617081011882368*^9, 3.6170810470424175`*^9}, {
   3.6170811130825095`*^9, 3.617081154182567*^9}, {3.6170812064726405`*^9, 
   3.617081224152665*^9}, 3.61708140645292*^9, 3.617081497173047*^9, {
   3.6170816852133102`*^9, 3.6170817270833693`*^9}, {3.617081944933674*^9, 
   3.6170823875142937`*^9}, {3.6170824181143365`*^9, 3.617082510004465*^9}, {
   3.6170825608945365`*^9, 3.6170826899847174`*^9}, {3.6170827284847713`*^9, 
   3.6170827757448373`*^9}, {3.617082816234894*^9, 3.6170828268349085`*^9}, {
   3.6170828616049576`*^9, 3.6170829449750743`*^9}, 3.617082991535139*^9, {
   3.617083036025202*^9, 3.6170830630852394`*^9}, {3.6170831051752987`*^9, 
   3.617083116975315*^9}, {3.6170831615053773`*^9, 3.6170832540955067`*^9}, {
   3.617083300555572*^9, 3.617083304755578*^9}, {3.6170833569656506`*^9, 
   3.6170834083157225`*^9}, {3.6170835325458965`*^9, 3.617083597205987*^9}, {
   3.617083703546136*^9, 3.617083727036169*^9}, {3.6170838003662715`*^9, 
   3.6170838072862816`*^9}, {3.6170838589763536`*^9, 
   3.6170838631563597`*^9}, {3.6170839431384726`*^9, 
   3.6170839458584766`*^9}, {3.6170839956085463`*^9, 
   3.6170839980085497`*^9}, {3.6170840564886312`*^9, 3.617084089848678*^9}, {
   3.6170844008191137`*^9, 3.617084414719133*^9}, {3.6170845042692585`*^9, 
   3.617084526439289*^9}, 3.617084642561453*^9, {3.6170846963215284`*^9, 
   3.617084808291685*^9}, {3.617084868321769*^9, 3.617084892381803*^9}, 
   3.61708508310207*^9, {3.6170855496447244`*^9, 3.6170855688267527`*^9}, {
   3.617085934754269*^9, 3.6170860423944197`*^9}, {3.617086221090673*^9, 
   3.617086250260714*^9}, 3.617086335463835*^9, {3.617086370701886*^9, 
   3.617086383691904*^9}, {3.6170864318119717`*^9, 3.617086504532073*^9}, 
   3.6170865510621386`*^9, {3.617086627822246*^9, 3.617086633472254*^9}, {
   3.61708668780233*^9, 3.6170867015823493`*^9}, {3.617086796710484*^9, 
   3.617086796860484*^9}, 3.6170868591455746`*^9, {3.6170889930855923`*^9, 
   3.617089050145672*^9}, {3.617089086055722*^9, 3.617089109315755*^9}, {
   3.617089146395807*^9, 3.6170892162859044`*^9}, {3.6170892618559685`*^9, 
   3.6170894598762455`*^9}, {3.617089581566416*^9, 3.6170897219066124`*^9}, {
   3.617089757406662*^9, 3.617089765416673*^9}, {3.617089799376721*^9, 
   3.6170898118867383`*^9}, {3.617089902856866*^9, 3.6170899665969553`*^9}, {
   3.6170900362770524`*^9, 3.617090152817216*^9}, {3.61709019168727*^9, 
   3.6170901956272755`*^9}, {3.6170902285073214`*^9, 3.617090229577323*^9}, {
   3.61709029839742*^9, 3.6170904648976526`*^9}, {3.6170905053777094`*^9, 
   3.617090531677746*^9}, {3.6170905738178053`*^9, 3.6170907021879845`*^9}, {
   3.617090771538082*^9, 3.6170907743880863`*^9}, 3.617090831558166*^9, {
   3.617090913838281*^9, 3.617090956668341*^9}, {3.6170910198384295`*^9, 
   3.61709144903903*^9}, {3.6170914832290783`*^9, 3.6170914834990788`*^9}, {
   3.6170916361292925`*^9, 3.6170918684596176`*^9}, {3.6170919475997286`*^9, 
   3.617091982939778*^9}, {3.6170921775320516`*^9, 3.617092177802052*^9}, {
   3.6170922743041883`*^9, 3.617092292264213*^9}, {3.6170923623843117`*^9, 
   3.617092386094345*^9}, {3.6170925224345355`*^9, 3.617092522684536*^9}, {
   3.6170927917549124`*^9, 3.617092792694914*^9}, {3.6170930725653057`*^9, 
   3.617093095665338*^9}, 3.61709331135564*^9, {3.6170934317458086`*^9, 
   3.617093432135809*^9}, {3.617093474805869*^9, 3.617093476855872*^9}, {
   3.6170935772760124`*^9, 3.6170935852060237`*^9}, 3.61709370337819*^9, {
   3.6170938946984577`*^9, 3.61709395335854*^9}, {3.617094074018709*^9, 
   3.61709407437871*^9}, {3.617094144728808*^9, 3.617094164208835*^9}, {
   3.6170941966388807`*^9, 3.617094358479107*^9}, {3.6170943953691587`*^9, 
   3.6170943999491653`*^9}, {3.6170945146493263`*^9, 3.617094550469376*^9}, {
   3.6170945975894423`*^9, 3.617094609619459*^9}, {3.6170946514995174`*^9, 
   3.617094713999605*^9}, 3.6170947693696823`*^9, 3.617094855469803*^9, {
   3.6170948888498497`*^9, 3.6170950112700214`*^9}, {3.617095071100105*^9, 
   3.617095100360146*^9}, {3.617095240310342*^9, 3.617095245540349*^9}, {
   3.61709531756045*^9, 3.6170953344304733`*^9}, {3.6170955582907867`*^9, 
   3.6170957949311185`*^9}, {3.6170959030812693`*^9, 
   3.6170959342213135`*^9}, {3.6170960768415127`*^9, 3.617096143631606*^9}, {
   3.6170961875316677`*^9, 3.6170962440617476`*^9}, {3.617096295641819*^9, 
   3.6170963013818274`*^9}, {3.6170963654819174`*^9, 3.6170963657319174`*^9}, 
   3.6170964275320044`*^9, 3.6170965078521166`*^9, {3.617096605272253*^9, 
   3.6170966401223016`*^9}, {3.617096751932458*^9, 3.617096777092493*^9}, {
   3.617096849732595*^9, 3.617096852892599*^9}, {3.617096933802713*^9, 
   3.617096936292716*^9}, {3.6170970101128197`*^9, 3.6170970488828735`*^9}, {
   3.6170971035049515`*^9, 3.6170971397050023`*^9}, {3.617097205117095*^9, 
   3.617097238087141*^9}, {3.6170973833573446`*^9, 3.6170974282874074`*^9}, {
   3.617097778945512*^9, 3.6170978185755672`*^9}, {3.617170412837573*^9, 
   3.617170561773786*^9}, {3.6171706445539017`*^9, 3.617170705323987*^9}, {
   3.6171707378960342`*^9, 3.6171708564061995`*^9}, {3.6171709047562675`*^9, 
   3.617170951736333*^9}, {3.617171003716406*^9, 3.617171009996415*^9}, {
   3.6171711275565796`*^9, 3.617171147886608*^9}, {3.617171201566683*^9, 
   3.617171207276691*^9}, 3.6171712430867414`*^9, {3.6171712777967896`*^9, 
   3.6171713648469114`*^9}, 3.6171714035469656`*^9, {3.6171714399990177`*^9, 
   3.6171714613790483`*^9}, {3.6171718015495243`*^9, 3.61717188432964*^9}, {
   3.6171720185798283`*^9, 3.617172059889886*^9}, {3.617172092229931*^9, 
   3.6171720969199376`*^9}, {3.617172135661993*^9, 3.617172178952054*^9}, {
   3.6171722237841177`*^9, 3.6171722387341385`*^9}, {3.6171722983542223`*^9, 
   3.6171723390742793`*^9}, 3.6171723860143447`*^9, {3.6171724293444057`*^9, 
   3.6171724376644173`*^9}, {3.6171725205365343`*^9, 
   3.6171725488665743`*^9}, {3.61717258182662*^9, 3.61717258876663*^9}, {
   3.617172667986741*^9, 3.6171726860667663`*^9}, {3.6171728417399855`*^9, 
   3.6171729015900693`*^9}, {3.6171730557422867`*^9, 3.617173124912383*^9}, {
   3.6171732965126233`*^9, 3.6171732994526277`*^9}, {3.617257103679963*^9, 
   3.617257236000148*^9}, {3.6172572683001933`*^9, 3.617257273710201*^9}, {
   3.6172573285402775`*^9, 3.617257561470604*^9}, {3.61725766596075*^9, 
   3.61725769458079*^9}, {3.617257774020901*^9, 3.6172577788909082`*^9}, {
   3.676379229716907*^9, 3.676379356608203*^9}, {3.676379391596739*^9, 
   3.6763795458509192`*^9}, {3.6763796271292095`*^9, 3.676379638566965*^9}, {
   3.6763796890320263`*^9, 3.676379738696488*^9}, 3.676379795024036*^9, {
   3.676379851041288*^9, 3.6763799082972984`*^9}, {3.6763800087727714`*^9, 
   3.6763801683115854`*^9}, {3.676380201455246*^9, 3.676380252735607*^9}, {
   3.676380289996436*^9, 3.6763803193852577`*^9}, {3.6763804134152613`*^9, 
   3.676380425349003*^9}, {3.676380482570793*^9, 3.676380482870634*^9}, 
   3.676380558281166*^9, {3.676380602482889*^9, 3.6763808028622017`*^9}, {
   3.6763808344830832`*^9, 3.676380834598652*^9}, {3.6763809711324663`*^9, 
   3.6763809876323123`*^9}, {3.676431723625582*^9, 3.676431800372013*^9}, {
   3.6764318353478775`*^9, 3.676431924316069*^9}, {3.67643195941407*^9, 
   3.676432028932928*^9}, {3.676432099536168*^9, 3.6764321482013063`*^9}, {
   3.6764322095800943`*^9, 3.676432447735777*^9}, {3.676432484480308*^9, 
   3.6764324936587358`*^9}, {3.6764325330858684`*^9, 3.6764325344015527`*^9}, 
   3.6764326241609244`*^9, {3.6764326684432945`*^9, 3.676432699602292*^9}, {
   3.676432821889718*^9, 3.6764328224047194`*^9}, {3.6764333996861677`*^9, 
   3.676433400203241*^9}, {3.7666546352788973`*^9, 3.7666546473851805`*^9}, 
   3.7666547219351387`*^9, {3.766654756787177*^9, 3.7666549079133186`*^9}, {
   3.766654942052092*^9, 3.7666552877068176`*^9}, 3.766655318519355*^9, {
   3.7690483355378275`*^9, 3.7690485456186104`*^9}, {3.7690584450088034`*^9, 
   3.7690584483347206`*^9}, {3.7690584790479226`*^9, 
   3.7690585336084948`*^9}, {3.7690587671504107`*^9, 3.769058790547804*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"AKSIJALNO NAPREZANJE\"\>"], "Print",
 CellChangeTimes->{
  3.6172578027309413`*^9, {3.621061873754172*^9, 3.62106189841638*^9}, 
   3.6763793071271315`*^9, 3.6763793579515963`*^9, 3.676379583942707*^9, 
   3.676379643993083*^9, 3.67637976119016*^9, 3.6763797982223635`*^9, 
   3.676379950528572*^9, 3.676380277091069*^9, 3.676380333152449*^9, {
   3.676380399023095*^9, 3.676380427956376*^9}, 3.676380492168865*^9, 
   3.6763805619248285`*^9, 3.6763808424252386`*^9, 3.676380989982637*^9, 
   3.6763810463961687`*^9, 3.6764324315079255`*^9, 3.676432496060848*^9, 
   3.676432537038977*^9, 3.6764327027895713`*^9, 3.6764328257609763`*^9, 
   3.7666548324974594`*^9, 3.766654921479085*^9, 3.766655290475215*^9, 
   3.7666553206019497`*^9, 3.7690485699869823`*^9, 3.7690584488897038`*^9, 
   3.7690584834248056`*^9, {3.7690585191068726`*^9, 3.7690585400293274`*^9}, {
   3.7690587718822875`*^9, 3.7690587948796883`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"matricaPrvihIzvodaNaks = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox["1", "L"]}], 
        FractionBox["1", "L"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["matricaPrvihIzvodaNaks = ", 
   MatrixForm[{{(-1)/$CellContext`L, $CellContext`L^(-1)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6172578027309413`*^9, {3.621061873754172*^9, 3.62106189841638*^9}, 
   3.6763793071271315`*^9, 3.6763793579515963`*^9, 3.676379583942707*^9, 
   3.676379643993083*^9, 3.67637976119016*^9, 3.6763797982223635`*^9, 
   3.676379950528572*^9, 3.676380277091069*^9, 3.676380333152449*^9, {
   3.676380399023095*^9, 3.676380427956376*^9}, 3.676380492168865*^9, 
   3.6763805619248285`*^9, 3.6763808424252386`*^9, 3.676380989982637*^9, 
   3.6763810463961687`*^9, 3.6764324315079255`*^9, 3.676432496060848*^9, 
   3.676432537038977*^9, 3.6764327027895713`*^9, 3.6764328257609763`*^9, 
   3.7666548324974594`*^9, 3.766654921479085*^9, 3.766655290475215*^9, 
   3.7666553206019497`*^9, 3.7690485699869823`*^9, 3.7690584488897038`*^9, 
   3.7690584834248056`*^9, {3.7690585191068726`*^9, 3.7690585400293274`*^9}, {
   3.7690587718822875`*^9, 3.7690587948906875`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"kaks = \\!\\(\\*FractionBox[\\(EA\\), \\(L\\)]\\)\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", 
        RowBox[{"-", "1"}]},
       {
        RowBox[{"-", "1"}], "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["kaks = \!\(\*FractionBox[\(EA\), \(L\)]\)", 
   MatrixForm[{{1, -1}, {-1, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6172578027309413`*^9, {3.621061873754172*^9, 3.62106189841638*^9}, 
   3.6763793071271315`*^9, 3.6763793579515963`*^9, 3.676379583942707*^9, 
   3.676379643993083*^9, 3.67637976119016*^9, 3.6763797982223635`*^9, 
   3.676379950528572*^9, 3.676380277091069*^9, 3.676380333152449*^9, {
   3.676380399023095*^9, 3.676380427956376*^9}, 3.676380492168865*^9, 
   3.6763805619248285`*^9, 3.6763808424252386`*^9, 3.676380989982637*^9, 
   3.6763810463961687`*^9, 3.6764324315079255`*^9, 3.676432496060848*^9, 
   3.676432537038977*^9, 3.6764327027895713`*^9, 3.6764328257609763`*^9, 
   3.7666548324974594`*^9, 3.766654921479085*^9, 3.766655290475215*^9, 
   3.7666553206019497`*^9, 3.7690485699869823`*^9, 3.7690584488897038`*^9, 
   3.7690584834248056`*^9, {3.7690585191068726`*^9, 3.7690585400293274`*^9}, {
   3.7690587718822875`*^9, 3.769058794945686*^9}}],

Cell[BoxData["\<\"SAVIJANJE U x-y RAVNI\"\>"], "Print",
 CellChangeTimes->{
  3.6172578027309413`*^9, {3.621061873754172*^9, 3.62106189841638*^9}, 
   3.6763793071271315`*^9, 3.6763793579515963`*^9, 3.676379583942707*^9, 
   3.676379643993083*^9, 3.67637976119016*^9, 3.6763797982223635`*^9, 
   3.676379950528572*^9, 3.676380277091069*^9, 3.676380333152449*^9, {
   3.676380399023095*^9, 3.676380427956376*^9}, 3.676380492168865*^9, 
   3.6763805619248285`*^9, 3.6763808424252386`*^9, 3.676380989982637*^9, 
   3.6763810463961687`*^9, 3.6764324315079255`*^9, 3.676432496060848*^9, 
   3.676432537038977*^9, 3.6764327027895713`*^9, 3.6764328257609763`*^9, 
   3.7666548324974594`*^9, 3.766654921479085*^9, 3.766655290475215*^9, 
   3.7666553206019497`*^9, 3.7690485699869823`*^9, 3.7690584488897038`*^9, 
   3.7690584834248056`*^9, {3.7690585191068726`*^9, 3.7690585400293274`*^9}, {
   3.7690587718822875`*^9, 3.7690587949486856`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"matricaDrugihIzvodaNxy = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox["6", 
           SuperscriptBox["L", "2"]]}], "+", 
         FractionBox[
          RowBox[{"12", " ", "x"}], 
          SuperscriptBox["L", "3"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox["4", "L"]}], "+", 
         FractionBox[
          RowBox[{"6", " ", "x"}], 
          SuperscriptBox["L", "2"]]}], 
        RowBox[{
         FractionBox["6", 
          SuperscriptBox["L", "2"]], "-", 
         FractionBox[
          RowBox[{"12", " ", "x"}], 
          SuperscriptBox["L", "3"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox["2", "L"]}], "+", 
         FractionBox[
          RowBox[{"6", " ", "x"}], 
          SuperscriptBox["L", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["matricaDrugihIzvodaNxy = ", 
   MatrixForm[{{(-6) $CellContext`L^(-2) + 
      12 $CellContext`L^(-3) $CellContext`x, (-4)/$CellContext`L + 
      6 $CellContext`L^(-2) $CellContext`x, 6 $CellContext`L^(-2) - 
      12 $CellContext`L^(-3) $CellContext`x, (-2)/$CellContext`L + 
      6 $CellContext`L^(-2) $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6172578027309413`*^9, {3.621061873754172*^9, 3.62106189841638*^9}, 
   3.6763793071271315`*^9, 3.6763793579515963`*^9, 3.676379583942707*^9, 
   3.676379643993083*^9, 3.67637976119016*^9, 3.6763797982223635`*^9, 
   3.676379950528572*^9, 3.676380277091069*^9, 3.676380333152449*^9, {
   3.676380399023095*^9, 3.676380427956376*^9}, 3.676380492168865*^9, 
   3.6763805619248285`*^9, 3.6763808424252386`*^9, 3.676380989982637*^9, 
   3.6763810463961687`*^9, 3.6764324315079255`*^9, 3.676432496060848*^9, 
   3.676432537038977*^9, 3.6764327027895713`*^9, 3.6764328257609763`*^9, 
   3.7666548324974594`*^9, 3.766654921479085*^9, 3.766655290475215*^9, 
   3.7666553206019497`*^9, 3.7690485699869823`*^9, 3.7690584488897038`*^9, 
   3.7690584834248056`*^9, {3.7690585191068726`*^9, 3.7690585400293274`*^9}, {
   3.7690587718822875`*^9, 3.769058794967685*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"matricaPrvihIzvodaNxy = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"6", " ", "x"}], 
           SuperscriptBox["L", "2"]]}], "+", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["x", "2"]}], 
          SuperscriptBox["L", "3"]]}], 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"4", " ", "x"}], "L"], "+", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["x", "2"]}], 
          SuperscriptBox["L", "2"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"6", " ", "x"}], 
          SuperscriptBox["L", "2"]], "-", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["x", "2"]}], 
          SuperscriptBox["L", "3"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", "x"}], "L"]}], "+", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["x", "2"]}], 
          SuperscriptBox["L", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["matricaPrvihIzvodaNxy = ", 
   MatrixForm[{{(-6) $CellContext`L^(-2) $CellContext`x + 
      6 $CellContext`L^(-3) $CellContext`x^2, 1 - 
      4 $CellContext`L^(-1) $CellContext`x + 
      3 $CellContext`L^(-2) $CellContext`x^2, 
      6 $CellContext`L^(-2) $CellContext`x - 
      6 $CellContext`L^(-3) $CellContext`x^2, (-2) $CellContext`L^(-1) \
$CellContext`x + 3 $CellContext`L^(-2) $CellContext`x^2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6172578027309413`*^9, {3.621061873754172*^9, 3.62106189841638*^9}, 
   3.6763793071271315`*^9, 3.6763793579515963`*^9, 3.676379583942707*^9, 
   3.676379643993083*^9, 3.67637976119016*^9, 3.6763797982223635`*^9, 
   3.676379950528572*^9, 3.676380277091069*^9, 3.676380333152449*^9, {
   3.676380399023095*^9, 3.676380427956376*^9}, 3.676380492168865*^9, 
   3.6763805619248285`*^9, 3.6763808424252386`*^9, 3.676380989982637*^9, 
   3.6763810463961687`*^9, 3.6764324315079255`*^9, 3.676432496060848*^9, 
   3.676432537038977*^9, 3.6764327027895713`*^9, 3.6764328257609763`*^9, 
   3.7666548324974594`*^9, 3.766654921479085*^9, 3.766655290475215*^9, 
   3.7666553206019497`*^9, 3.7690485699869823`*^9, 3.7690584488897038`*^9, 
   3.7690584834248056`*^9, {3.7690585191068726`*^9, 3.7690585400293274`*^9}, {
   3.7690587718822875`*^9, 3.7690587949736853`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Konvencionalna matrica krutosti kxy = \
\\!\\(\\*FractionBox[\\(EIz\\), SuperscriptBox[\\(L\\), \\(3\\)]]\\)\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"12", 
        RowBox[{"6", " ", "L"}], 
        RowBox[{"-", "12"}], 
        RowBox[{"6", " ", "L"}]},
       {
        RowBox[{"6", " ", "L"}], 
        RowBox[{"4", " ", 
         SuperscriptBox["L", "2"]}], 
        RowBox[{
         RowBox[{"-", "6"}], " ", "L"}], 
        RowBox[{"2", " ", 
         SuperscriptBox["L", "2"]}]},
       {
        RowBox[{"-", "12"}], 
        RowBox[{
         RowBox[{"-", "6"}], " ", "L"}], "12", 
        RowBox[{
         RowBox[{"-", "6"}], " ", "L"}]},
       {
        RowBox[{"6", " ", "L"}], 
        RowBox[{"2", " ", 
         SuperscriptBox["L", "2"]}], 
        RowBox[{
         RowBox[{"-", "6"}], " ", "L"}], 
        RowBox[{"4", " ", 
         SuperscriptBox["L", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Konvencionalna matrica krutosti kxy = \!\(\*FractionBox[\(EIz\), \
SuperscriptBox[\(L\), \(3\)]]\)", 
   MatrixForm[{{12, 6 $CellContext`L, -12, 6 $CellContext`L}, {
     6 $CellContext`L, 4 $CellContext`L^2, (-6) $CellContext`L, 
      2 $CellContext`L^2}, {-12, (-6) $CellContext`L, 
      12, (-6) $CellContext`L}, {
     6 $CellContext`L, 2 $CellContext`L^2, (-6) $CellContext`L, 
      4 $CellContext`L^2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6172578027309413`*^9, {3.621061873754172*^9, 3.62106189841638*^9}, 
   3.6763793071271315`*^9, 3.6763793579515963`*^9, 3.676379583942707*^9, 
   3.676379643993083*^9, 3.67637976119016*^9, 3.6763797982223635`*^9, 
   3.676379950528572*^9, 3.676380277091069*^9, 3.676380333152449*^9, {
   3.676380399023095*^9, 3.676380427956376*^9}, 3.676380492168865*^9, 
   3.6763805619248285`*^9, 3.6763808424252386`*^9, 3.676380989982637*^9, 
   3.6763810463961687`*^9, 3.6764324315079255`*^9, 3.676432496060848*^9, 
   3.676432537038977*^9, 3.6764327027895713`*^9, 3.6764328257609763`*^9, 
   3.7666548324974594`*^9, 3.766654921479085*^9, 3.766655290475215*^9, 
   3.7666553206019497`*^9, 3.7690485699869823`*^9, 3.7690584488897038`*^9, 
   3.7690584834248056`*^9, {3.7690585191068726`*^9, 3.7690585400293274`*^9}, {
   3.7690587718822875`*^9, 3.769058795081682*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Geometrijska matrica krutosti kxyg = \\!\\(\\*FractionBox[\\(S\
\\), \\(30  L\\)]\\)\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"36", 
        RowBox[{"3", " ", "L"}], 
        RowBox[{"-", "36"}], 
        RowBox[{"3", " ", "L"}]},
       {
        RowBox[{"3", " ", "L"}], 
        RowBox[{"4", " ", 
         SuperscriptBox["L", "2"]}], 
        RowBox[{
         RowBox[{"-", "3"}], " ", "L"}], 
        RowBox[{"-", 
         SuperscriptBox["L", "2"]}]},
       {
        RowBox[{"-", "36"}], 
        RowBox[{
         RowBox[{"-", "3"}], " ", "L"}], "36", 
        RowBox[{
         RowBox[{"-", "3"}], " ", "L"}]},
       {
        RowBox[{"3", " ", "L"}], 
        RowBox[{"-", 
         SuperscriptBox["L", "2"]}], 
        RowBox[{
         RowBox[{"-", "3"}], " ", "L"}], 
        RowBox[{"4", " ", 
         SuperscriptBox["L", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Geometrijska matrica krutosti kxyg = \!\(\*FractionBox[\(S\), \(30  \
L\)]\)", 
   MatrixForm[{{36, 3 $CellContext`L, -36, 3 $CellContext`L}, {
     3 $CellContext`L, 
      4 $CellContext`L^2, (-3) $CellContext`L, -$CellContext`L^2}, {-36, (-3) \
$CellContext`L, 36, (-3) $CellContext`L}, {
     3 $CellContext`L, -$CellContext`L^2, (-3) $CellContext`L, 
      4 $CellContext`L^2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6172578027309413`*^9, {3.621061873754172*^9, 3.62106189841638*^9}, 
   3.6763793071271315`*^9, 3.6763793579515963`*^9, 3.676379583942707*^9, 
   3.676379643993083*^9, 3.67637976119016*^9, 3.6763797982223635`*^9, 
   3.676379950528572*^9, 3.676380277091069*^9, 3.676380333152449*^9, {
   3.676380399023095*^9, 3.676380427956376*^9}, 3.676380492168865*^9, 
   3.6763805619248285`*^9, 3.6763808424252386`*^9, 3.676380989982637*^9, 
   3.6763810463961687`*^9, 3.6764324315079255`*^9, 3.676432496060848*^9, 
   3.676432537038977*^9, 3.6764327027895713`*^9, 3.6764328257609763`*^9, 
   3.7666548324974594`*^9, 3.766654921479085*^9, 3.766655290475215*^9, 
   3.7666553206019497`*^9, 3.7690485699869823`*^9, 3.7690584488897038`*^9, 
   3.7690584834248056`*^9, {3.7690585191068726`*^9, 3.7690585400293274`*^9}, {
   3.7690587718822875`*^9, 3.7690587952046795`*^9}}],

Cell[BoxData["\<\"SAVIJANJE U x-z RAVNI\"\>"], "Print",
 CellChangeTimes->{
  3.6172578027309413`*^9, {3.621061873754172*^9, 3.62106189841638*^9}, 
   3.6763793071271315`*^9, 3.6763793579515963`*^9, 3.676379583942707*^9, 
   3.676379643993083*^9, 3.67637976119016*^9, 3.6763797982223635`*^9, 
   3.676379950528572*^9, 3.676380277091069*^9, 3.676380333152449*^9, {
   3.676380399023095*^9, 3.676380427956376*^9}, 3.676380492168865*^9, 
   3.6763805619248285`*^9, 3.6763808424252386`*^9, 3.676380989982637*^9, 
   3.6763810463961687`*^9, 3.6764324315079255`*^9, 3.676432496060848*^9, 
   3.676432537038977*^9, 3.6764327027895713`*^9, 3.6764328257609763`*^9, 
   3.7666548324974594`*^9, 3.766654921479085*^9, 3.766655290475215*^9, 
   3.7666553206019497`*^9, 3.7690485699869823`*^9, 3.7690584488897038`*^9, 
   3.7690584834248056`*^9, {3.7690585191068726`*^9, 3.7690585400293274`*^9}, {
   3.7690587718822875`*^9, 3.769058795208679*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"matricaDrugihIzvodaNxz  = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox["6", 
           SuperscriptBox["L", "2"]]}], "+", 
         FractionBox[
          RowBox[{"12", " ", "x"}], 
          SuperscriptBox["L", "3"]]}], 
        RowBox[{
         FractionBox["4", "L"], "-", 
         FractionBox[
          RowBox[{"6", " ", "x"}], 
          SuperscriptBox["L", "2"]]}], 
        RowBox[{
         FractionBox["6", 
          SuperscriptBox["L", "2"]], "-", 
         FractionBox[
          RowBox[{"12", " ", "x"}], 
          SuperscriptBox["L", "3"]]}], 
        RowBox[{
         FractionBox["2", "L"], "-", 
         FractionBox[
          RowBox[{"6", " ", "x"}], 
          SuperscriptBox["L", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["matricaDrugihIzvodaNxz  = ", 
   MatrixForm[{{(-6) $CellContext`L^(-2) + 
      12 $CellContext`L^(-3) $CellContext`x, 4/$CellContext`L - 
      6 $CellContext`L^(-2) $CellContext`x, 6 $CellContext`L^(-2) - 
      12 $CellContext`L^(-3) $CellContext`x, 2/$CellContext`L - 
      6 $CellContext`L^(-2) $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6172578027309413`*^9, {3.621061873754172*^9, 3.62106189841638*^9}, 
   3.6763793071271315`*^9, 3.6763793579515963`*^9, 3.676379583942707*^9, 
   3.676379643993083*^9, 3.67637976119016*^9, 3.6763797982223635`*^9, 
   3.676379950528572*^9, 3.676380277091069*^9, 3.676380333152449*^9, {
   3.676380399023095*^9, 3.676380427956376*^9}, 3.676380492168865*^9, 
   3.6763805619248285`*^9, 3.6763808424252386`*^9, 3.676380989982637*^9, 
   3.6763810463961687`*^9, 3.6764324315079255`*^9, 3.676432496060848*^9, 
   3.676432537038977*^9, 3.6764327027895713`*^9, 3.6764328257609763`*^9, 
   3.7666548324974594`*^9, 3.766654921479085*^9, 3.766655290475215*^9, 
   3.7666553206019497`*^9, 3.7690485699869823`*^9, 3.7690584488897038`*^9, 
   3.7690584834248056`*^9, {3.7690585191068726`*^9, 3.7690585400293274`*^9}, {
   3.7690587718822875`*^9, 3.7690587952116785`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"matricaPrvihIzvodaNxz = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"6", " ", "x"}], 
           SuperscriptBox["L", "2"]]}], "+", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["x", "2"]}], 
          SuperscriptBox["L", "3"]]}], 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         FractionBox[
          RowBox[{"4", " ", "x"}], "L"], "-", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["x", "2"]}], 
          SuperscriptBox["L", "2"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"6", " ", "x"}], 
          SuperscriptBox["L", "2"]], "-", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["x", "2"]}], 
          SuperscriptBox["L", "3"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", "x"}], "L"], "-", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["x", "2"]}], 
          SuperscriptBox["L", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["matricaPrvihIzvodaNxz = ", 
   MatrixForm[{{(-6) $CellContext`L^(-2) $CellContext`x + 
      6 $CellContext`L^(-3) $CellContext`x^2, -1 + 
      4 $CellContext`L^(-1) $CellContext`x - 
      3 $CellContext`L^(-2) $CellContext`x^2, 
      6 $CellContext`L^(-2) $CellContext`x - 
      6 $CellContext`L^(-3) $CellContext`x^2, 
      2 $CellContext`L^(-1) $CellContext`x - 
      3 $CellContext`L^(-2) $CellContext`x^2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6172578027309413`*^9, {3.621061873754172*^9, 3.62106189841638*^9}, 
   3.6763793071271315`*^9, 3.6763793579515963`*^9, 3.676379583942707*^9, 
   3.676379643993083*^9, 3.67637976119016*^9, 3.6763797982223635`*^9, 
   3.676379950528572*^9, 3.676380277091069*^9, 3.676380333152449*^9, {
   3.676380399023095*^9, 3.676380427956376*^9}, 3.676380492168865*^9, 
   3.6763805619248285`*^9, 3.6763808424252386`*^9, 3.676380989982637*^9, 
   3.6763810463961687`*^9, 3.6764324315079255`*^9, 3.676432496060848*^9, 
   3.676432537038977*^9, 3.6764327027895713`*^9, 3.6764328257609763`*^9, 
   3.7666548324974594`*^9, 3.766654921479085*^9, 3.766655290475215*^9, 
   3.7666553206019497`*^9, 3.7690485699869823`*^9, 3.7690584488897038`*^9, 
   3.7690584834248056`*^9, {3.7690585191068726`*^9, 3.7690585400293274`*^9}, {
   3.7690587718822875`*^9, 3.7690587952166786`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Konvencionalna matrica krutosti kxz = \
\\!\\(\\*FractionBox[\\(EIy\\), SuperscriptBox[\\(L\\), \\(3\\)]]\\)\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"12", 
        RowBox[{
         RowBox[{"-", "6"}], " ", "L"}], 
        RowBox[{"-", "12"}], 
        RowBox[{
         RowBox[{"-", "6"}], " ", "L"}]},
       {
        RowBox[{
         RowBox[{"-", "6"}], " ", "L"}], 
        RowBox[{"4", " ", 
         SuperscriptBox["L", "2"]}], 
        RowBox[{"6", " ", "L"}], 
        RowBox[{"2", " ", 
         SuperscriptBox["L", "2"]}]},
       {
        RowBox[{"-", "12"}], 
        RowBox[{"6", " ", "L"}], "12", 
        RowBox[{"6", " ", "L"}]},
       {
        RowBox[{
         RowBox[{"-", "6"}], " ", "L"}], 
        RowBox[{"2", " ", 
         SuperscriptBox["L", "2"]}], 
        RowBox[{"6", " ", "L"}], 
        RowBox[{"4", " ", 
         SuperscriptBox["L", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Konvencionalna matrica krutosti kxz = \!\(\*FractionBox[\(EIy\), \
SuperscriptBox[\(L\), \(3\)]]\)", 
   MatrixForm[{{
     12, (-6) $CellContext`L, -12, (-6) $CellContext`L}, {(-6) $CellContext`L,
       4 $CellContext`L^2, 6 $CellContext`L, 2 $CellContext`L^2}, {-12, 
      6 $CellContext`L, 12, 6 $CellContext`L}, {(-6) $CellContext`L, 
      2 $CellContext`L^2, 6 $CellContext`L, 4 $CellContext`L^2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6172578027309413`*^9, {3.621061873754172*^9, 3.62106189841638*^9}, 
   3.6763793071271315`*^9, 3.6763793579515963`*^9, 3.676379583942707*^9, 
   3.676379643993083*^9, 3.67637976119016*^9, 3.6763797982223635`*^9, 
   3.676379950528572*^9, 3.676380277091069*^9, 3.676380333152449*^9, {
   3.676380399023095*^9, 3.676380427956376*^9}, 3.676380492168865*^9, 
   3.6763805619248285`*^9, 3.6763808424252386`*^9, 3.676380989982637*^9, 
   3.6763810463961687`*^9, 3.6764324315079255`*^9, 3.676432496060848*^9, 
   3.676432537038977*^9, 3.6764327027895713`*^9, 3.6764328257609763`*^9, 
   3.7666548324974594`*^9, 3.766654921479085*^9, 3.766655290475215*^9, 
   3.7666553206019497`*^9, 3.7690485699869823`*^9, 3.7690584488897038`*^9, 
   3.7690584834248056`*^9, {3.7690585191068726`*^9, 3.7690585400293274`*^9}, {
   3.7690587718822875`*^9, 3.769058795295676*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Geometrijska matrica krutosti kxzg = \\!\\(\\*FractionBox[\\(S\
\\), \\(30  L\\)]\\)\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"36", 
        RowBox[{
         RowBox[{"-", "3"}], " ", "L"}], 
        RowBox[{"-", "36"}], 
        RowBox[{
         RowBox[{"-", "3"}], " ", "L"}]},
       {
        RowBox[{
         RowBox[{"-", "3"}], " ", "L"}], 
        RowBox[{"4", " ", 
         SuperscriptBox["L", "2"]}], 
        RowBox[{"3", " ", "L"}], 
        RowBox[{"-", 
         SuperscriptBox["L", "2"]}]},
       {
        RowBox[{"-", "36"}], 
        RowBox[{"3", " ", "L"}], "36", 
        RowBox[{"3", " ", "L"}]},
       {
        RowBox[{
         RowBox[{"-", "3"}], " ", "L"}], 
        RowBox[{"-", 
         SuperscriptBox["L", "2"]}], 
        RowBox[{"3", " ", "L"}], 
        RowBox[{"4", " ", 
         SuperscriptBox["L", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Geometrijska matrica krutosti kxzg = \!\(\*FractionBox[\(S\), \(30  \
L\)]\)", 
   MatrixForm[{{
     36, (-3) $CellContext`L, -36, (-3) $CellContext`L}, {(-3) $CellContext`L,
       4 $CellContext`L^2, 3 $CellContext`L, -$CellContext`L^2}, {-36, 
      3 $CellContext`L, 36, 
      3 $CellContext`L}, {(-3) $CellContext`L, -$CellContext`L^2, 
      3 $CellContext`L, 4 $CellContext`L^2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6172578027309413`*^9, {3.621061873754172*^9, 3.62106189841638*^9}, 
   3.6763793071271315`*^9, 3.6763793579515963`*^9, 3.676379583942707*^9, 
   3.676379643993083*^9, 3.67637976119016*^9, 3.6763797982223635`*^9, 
   3.676379950528572*^9, 3.676380277091069*^9, 3.676380333152449*^9, {
   3.676380399023095*^9, 3.676380427956376*^9}, 3.676380492168865*^9, 
   3.6763805619248285`*^9, 3.6763808424252386`*^9, 3.676380989982637*^9, 
   3.6763810463961687`*^9, 3.6764324315079255`*^9, 3.676432496060848*^9, 
   3.676432537038977*^9, 3.6764327027895713`*^9, 3.6764328257609763`*^9, 
   3.7666548324974594`*^9, 3.766654921479085*^9, 3.766655290475215*^9, 
   3.7666553206019497`*^9, 3.7690485699869823`*^9, 3.7690584488897038`*^9, 
   3.7690584834248056`*^9, {3.7690585191068726`*^9, 3.7690585400293274`*^9}, {
   3.7690587718822875`*^9, 3.769058795403674*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1920, 997},
WindowMargins->{{1912, Automatic}, {Automatic, -8}},
PrintingCopies->1,
PrintingStartingPageNumber->1,
PrintingPageRange->{32000, 32000},
PageHeaders->{{None, None, None}, {None, None, None}},
PageFooters->{{None, 
   Cell[
    TextData[
     CounterBox["Page", CounterFunction :> Identity]], "Footer"], None}, {
  None, 
   Cell[
    TextData[
     CounterBox["Page", CounterFunction :> Identity]], "Footer"], None}},
PageHeaderLines->{False, False},
PageFooterLines->{False, False},
PrintingOptions->{"FacingPages"->True,
"FirstPageFace"->Right,
"FirstPageFooter"->True,
"FirstPageHeader"->False,
"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{396.71999999999997`, 561.12},
"PrintingMargins"->36},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> True}},
Magnification->1.25,
FrontEndVersion->"10.2 for Microsoft Windows (64-bit) (July 7, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 37811, 739, 1298, "Input"],
Cell[CellGroupData[{
Cell[38403, 765, 935, 13, 27, "Print"],
Cell[39341, 780, 1777, 37, 37, "Print"],
Cell[41121, 819, 1781, 38, 44, "Print"],
Cell[42905, 859, 936, 13, 27, "Print"],
Cell[43844, 874, 2678, 63, 37, "Print"],
Cell[46525, 939, 3004, 72, 40, "Print"],
Cell[49532, 1013, 2831, 68, 86, "Print"],
Cell[52366, 1083, 2766, 67, 84, "Print"],
Cell[55135, 1152, 934, 13, 27, "Print"],
Cell[56072, 1167, 2624, 61, 37, "Print"],
Cell[58699, 1230, 3012, 73, 40, "Print"],
Cell[61714, 1305, 2825, 67, 86, "Print"],
Cell[64542, 1374, 2770, 67, 84, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
